unit panunit;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ExtDlgs, StdCtrls, MPlayer;

type
  TPanoramaFrm = class(TForm)
    Panel1: TPanel;
    Image1: TImage;
    Timer1: TTimer;
    StopGomb: TButton;
    KilepGomb: TButton;
    ZeneGomb: TButton;
    MediaPlayer1: TMediaPlayer;
    Label1: TLabel;
    Label2: TLabel;
    Timer2: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure KilepGombClick(Sender: TObject);
    procedure StopGombClick(Sender: TObject);
    procedure ZeneGombClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PanoramaFrm: TPanoramaFrm;

implementation
{$R *.DFM}
const
  szStart = 'Start';  // a gombok lehetsges feliratai
  szStop  = 'Stop';

 {A Timer1Timer eljrs az idzt Interval jellemzjben ezredmsodpercekben
 belltott idkznknt hajtdik vgre.
 Feladata: a kp "mozgatsa", a megjelents koordintinak minden lpsben
 egy dX rtkkel val eltolsa.}

procedure TPanoramaFrm.Timer1Timer(Sender: TObject);
const
  dX : integer=5;
begin
  if (Image1.Left > -abs(dx)) or (Image1.Left < Panel1.Width+abs(dX)-Image1.Width)
    then dX:=-dX;
  Image1.Left := Image1.Left + dX;
end;

 {Ha a programot a Kilp gombra val kattintssal fejezzk be,
 s a zene lejtszsa mg folyik, akkor az eljrs lehetsget ad
 a felhasznlnak a zene kikapcsolsra.}
procedure TPanoramaFrm.KilepGombClick(Sender: TObject);
begin
  if ZeneGomb.Caption = szStop then
    if Application.MessageBox('Szeretn elbb kikapcsolni a zent?',
             'Figyelmeztets', MB_YESNO + MB_ICONQUESTION) = IDYES
      then MediaPlayer1.Close;    // mdialejtsz eszkz felszabadtsa
  Close;
end;

 {A kp mozgsnak lelltsa, ill. (jra-)indtsa a nyomgomb felirattl
 fggen. Ehhez az idzt ki- s bekapcsolst hasznljuk, miutn
 trtuk a gomb feliratt.}
procedure TPanoramaFrm.StopGombClick(Sender: TObject);
begin
  if Timer1.Enabled       // ha mkdik az idzt
    then StopGomb.Caption := szStart    // feliratvlts
    else StopGomb.Caption := szStop;
  Timer1.Enabled := not Timer1.Enabled; // az idzt be-, illetve kikapcsolsa
end;

 {A Zene gomb feirtnak vltoztatsa s a zene lejtszsnak indtsa,
 ill. lelltsa a gomb feirattl fggen.}
procedure TPanoramaFrm.ZeneGombClick(Sender: TObject);
begin
  if ZeneGomb.Caption = szStart then
  // kattintskor a gomb "Start" felirattal rendelkezett
    begin
      MediaPlayer1.Open;          // mdialejtsz megnyitsa
      MediaPlayer1.Play;          // zenelejtszs elindtsa
      ZeneGomb.Caption := szStop; // feliratvlts
    end
  else
    begin
      MediaPlayer1.Stop;           // zenelejtszs meglltsa
      MediaPlayer1.Close;          // mdialejtsz lezrsa
      ZeneGomb.Caption := szStart; // feliratvlts
    end;
  Timer2.Enabled := not Timer2.Enabled;   // az idzt be-, illetve kikapcsolsa
end;

procedure TPanoramaFrm.FormCreate(Sender: TObject);
const
  szZeneFajl  = 'Alafest.wav';     // a lejtszand hangfjl neve
begin
  // a program aktulis knyvtra + a hangfjl neve
  MediaPlayer1.FileName:=GetCurrentDir+'\'+szZeneFajl;
end;

procedure TPanoramaFrm.Timer2Timer(Sender: TObject);
begin
  with MediaPlayer1 do
   if Position >= Length then    // hangfjl vge
     begin
       Rewind;     // visszatekers
       Play;       // hanglejtszs elindtsa
     end;
end;

end.
